#!/usr/bin/perl
#
# filter.pl copyright 1997 Private World Communications
# by Mark Jeftovic (aka Stunt Pope) markjr@shmOOze.net
# current version at: http://AntiSpam.shmOOze.net/filter/
# see the README for copying/licensing/etc
#

#
# Change this to match where you have installed filter.pl
push(@INC, "/path/to/your/filter");

require 'config.h';
require 'rules.hdr.pl';
require 'rules.bod.pl';

require 5.001;


$HDR=&getHdr();
@MSG[0]=$HDR;


# changed Sep  3 1997 jmason: use <STDIN> instead of <>, since sendmail
# will (or at least used to ;) remove multiple runs of a .forward script
# if they contained the same script and arguments, hence people would lose
# mail if they shared the same filter.pl install.
@BODY=<STDIN>;

%HDR_INFO=parseHdr($HDR);

foreach $_ (0..$HDR_RULES-1) {
        unless($QUIT_ON_STRIKEOUT && $STRIKES >= $STRIKE_OUT) {
                $call="hdr_$_";
                $RESULT{$call}=&$call($_,%HDR_INFO);
                $STRIKES+=$RESULT{$call};
                }
        }

foreach $_ (0..$BOD_RULES-1) {
        unless($QUIT_ON_STRIKEOUT && $STRIKES >= $STRIKE_OUT) {
                $call="bod_$_";
                $RESULT{$call}=&$call($_,@BODY);
                $STRIKES+=$RESULT{$call};
                }
        }

#@result=values(%RESULT);
#foreach(@result) { $STRIKES+=$_;}
$tagIt = 0;
if($STRIKES>=$STRIKE_OUT) {
        # it's spam
        if($MAIL_READER==$ELM) { $MSG[0]=~s/\n$/\nStatus: O\n/;}
        elsif($MAIL_READER==$POPPER) {
                $MSG[0]=~s/\n$/\n$X_HDR_FLAG: $POP_FLAG\n/;
                $BIT_BUCKET=$MAIL_SPOOL;
                }
        if($EXPLAIN_MYSELF) {
                @summary=&explain(%RULE);
                push(@MSG,@summary);
                }
        if($DBASE_TYPE) {
                &update_dbase($hdr{'subject'},$hdr{'from'},$hdr{'message-id'})
                        || &Logit("Problem updating $DBM_FILE");
                }
        push(@MSG,@BODY);
        if ($JUST_TAG) {
                $tagIt = 1;
                }
        else {
                &fileIt($BIT_BUCKET,@MSG);
                exit;
                }
        }
if($EXPLAIN_EVERYTHING && $STRIKES) {
        @summary=&explain(%RULE);
        push(@MSG,@summary);
        }
push(@MSG,@BODY);

if ($tagIt) {
    for ($i = 0; $i < $#MSG; $i++) {
      $* = 1;
      if ($MSG[$i] =~ /^Subject: /) {
          $MSG[$i] =~ s/^Subject: /Subject: ${SUBJECT_LINE_TAG} /;
          last;               # got it
      }
      $* = 0;
    }
}

if ($MAIL_READER==$PIPE_FORWARD) {
      print STDOUT @MSG;

} elsif ($MAIL_READER==$MH_SLOCAL) {
      $possiblewarn = "Failed to run $SLOCAL_COMMAND, deferring delivery if pos
sible\n";
      if (!open (OUT, $SLOCAL_COMMAND)) {
          &Logit($possiblewarn); warn $possiblewarn; exit 75;
      }
      print OUT @MSG;
      if (!close (OUT)) { &Logit("$possiblewarn"); warn $possiblewarn; exit 75;
 }

} else {
      &fileIt($MAIL_SPOOL,@MSG);
}
exit;

sub fileIt {
local($file,@msg)=@_;
if(! -f $file) {
        `$TOUCH $file`
        }
open(OUT,">>$file") || &Logit("$file $!");
&lock();
foreach(@msg) { print OUT $_;}

# -bugfix: mail gets mangled if not seperated by at least one newline
if($msg[$#msq]!~/^\n/) { print OUT "\n"; }

close(OUT);
&unlock();
return;
}

sub lock {
return unless($USE_FLOCK);
flock(OUT, $LOCK_EX);
seek(OUT,0,2);
}

sub unlock {
return unless($USE_FLOCK);
flock(OUT, $LOCK_UN)
}

sub explain {
local(%rule)=@_;
my @i=(),$k,$v;
while(($k,$v)=each(%rule)) {
        my($str)=&tabs("$k: weight=$RESULT{$k}",3);
        unshift(@i, "$str $v\n") if($v && $k =~ /^hdr/);
        push(@i, "$str $v\n") if($v && $k =~ /^bod/);
        }
unshift(@i, "$STRIKES strikes and they're out! ($STRIKE_OUT is as much as I can
 take)\n");
unshift(@i, "\n---------------- filter.pl: Spam Filter Results v.$VERSION -------------------\n");
push(@i, "------------------- End of Spam Filter Results ------------------\n\n
");
return(@i);
}

sub allCaps {
local($str)=@_;
if(!$str || $str=~/[a-z]/) { return(0);}
return(1);
}

sub Adump {
local(@array)=@_;
my $i=0;
foreach $_ (@array) {print $_;$i++}
return $i;
}

sub AAdump {
local(%array)=@_;
my $i,$k,$v;
while(($k,$v)=each(%array)) {
        print "$k: $v\n";
        }
return($i);
}

sub getHdr {
my $i,$save1,$save2;
($save1,$save2)=($*,$/);
($*, $/) = (1, '');
$i=<STDIN>;
($*, $/) = ($save1, $save2);
return($i);
}

sub parseHdr {
#
# this routine originally pilfered from Brent Chapman's majordomo
# -same with getHdr() above     -markjr
#
local($data)=@_;
my $i=0,@data,%hdr;

$data =~ s/\n\s+/ /g;
@data=split('\n',$data);

# get the very first From line, if it's there...
 if(@data[0] =~ /^From/i) {
        ($junk, $FROM)=split(/From\s/i,@data[0]);
        splice(@data,0,1);
        }
foreach $_ (@data) {
        $i++;
        ($key, $val) = split(/:/,$_,2);
        $val=~s/^\s+//g;
        $val=~s/\s+$//g;
        $key =~ y/A-Z/a-z/;
        if (defined($hdr{$key})) {
                $hdr{$key} .= ", $val";
                }
        else {
                $hdr{$key} = $val;
                }
        }
return(%hdr);
}

sub tabs {
my($str,$num)=@_;
my($len)=length($str);
my($limit)=$num*$TAB_LEN;
while($limit>$len) {
        $str .= "\t";
        $limit -= $TAB_LEN;
        }
return($str);
}

sub update_dbase {
my($key, $from, $message_id)=@_;
my(%hash);
#
# we're gonna lose all whitespaces in the subject line from the spam.
# I dunno why really, but for some reason i think we should.
$key=~s/[^0-9a-zA-Z]//g;
$from=~s/[^0-9a-zA-Z]//g;
$message_id=~s/[^0-9a-zA-Z]//g;
# map it all to lower case -same reason
$key=~tr/[A-Z]/[a-z]/;
$from=~tr/[A-Z]/[a-z]/;
$message_id=~tr/[A-Z]/[a-z]/;
if($DBASE_TYPE==$DBM || $DBASE_TYPE==$DB) { 
	dbmopen(%hash, $DBM_FILE, 0660) || return(-1);
        if($hash{$key}) {
                # it's already in there
                ($message_id, $from, $count, $created, $modified)
                                = split(/\0/,$hash{$key});
                $count++;
                $modifed=time();
                }
        else    {
                # new entry
                $created=$modified=time();
                $count++;
                }
        $hash{$key}=join("\0",$message_id, $from, $count, $created, $modified);
        dbmclose(%hash);
        }
}

sub getEmailPatterns {
my($file)=@_;
my(@array);
if(!$file) { $file = "./addresses"; }
open(IN, $file) || &Logit("Can't find addresses file $file: $!");
while(<IN>) {
	next if($_ =~ /^#|^\n/);
	push(@array, $_);
	}
return(@array);
}

sub Logit {
my($msg, $log)=@_;
if(!$log) { $log = $LOG; }
if($USE_SYSLOG) {
#	use Sys::Syslog;
#	openlog("filter.pl", 'pid', 'daemon');
#	syslog('notice', $msg);
#	closelog();
	}
else	{
	return(-1) unless(-w $log);
	open(LOG, ">>$log") || return(-1);
	print LOG "$msg\n";
	close(LOG);
	}
return(0);
}
