#!/usr/bin/perl 
#
# spam_db_expire.pl v1.0
# this expires items from the filter.pl spam database
# by Stunt Pope <markjr@shmOOze.net> / Private World Communications
# 
$usage=<<"EOF";
usage: spam_db_expire.pl -e|-m -s n|-d n [-h]
switches:
-e	calculate time from date entered 
-m	calculate time from date modified 
-s	remove entries older than n seconds
-d	remove entries older than n days
-h	this stuff
EOF

use Getopt::Std;
getopts('ems:d:v');

umask 000;
use DB_File;
use Fcntl;

$count=0;


if($opt_h || (!($opt_e||$opt_m) || !($opt_s||$opt_d))) {
	print $usage;
	exit;
	}

if($opt_s) { $interval=$opt_s; }
else 	{ $interval=$opt_d*86400;}

$now=time();

$DB_FILE="/usr/local/etc/filter.db";
select STDOUT; $|=1;
dbmopen(%hash, $DB_FILE, 0660) || die $!;
#tie(%hash, "DB_File", $DB_FILE, O_RDWR, 0666, $DB_HASH) || die $!;
while(($key,$data)=each(%hash)) {
$rec++;
	if(!$data) {
		# i occassionally get entries with no data -i don't know why
		push(@doomed, $key);
		print "X";
		$count++;
		next;
		}
	($junk,$junk,$junk,$created,$modified)=split(/\0/,$data);
	if(!$created) { $created=0; }
	if(!$modified) { $modified=0; }
	if($opt_m) { $elapsed = $now-$modified; }
	else	{ $elapsed = $now-$created; }
	if($elapsed >= $interval) {
		push(@doomed, $key);
		$count++;
		print "x";
		}
	else { print ".";}
	}
delete @hash{@doomed};
dbmclose(%hash);
#untie %hash;

print " done.\nDeleted $count entires from $DB_FILE\n";
