
sub hdr_0 {
my $active=$DBASE_TYPE;
goto DONE unless($active);
local($num,%hdr)=@_;
my(%hash,$key,$val,$tmp_subj);
#
# Total weight for this chk
#
my $weight=$DBASE_HIT;
#
# Rule Description
#
$RULE{"hdr_$num"}="Found in local spam database";
#
# Rule Code
#
($tmp_subj=$hdr{'subject'})=~s/[^0-9a-zA-Z]//g;
$tmp_subj=~tr/[A-Z]/[a-z]/;
($tmp_msgid=$hdr{'message-id'})=~s/[^0-9a-zA-Z]//g;
$tmp_msgid=~tr/[A-Z]/[a-z]/;
if($DBASE_TYPE == $DBM || $DBASE_TYPE == $DB) {
        dbmopen(%hash, $DBM_FILE, 0660) || die $!;
        while(($key,$val)=each(%hash)) {
                my($message_id, $junk, $count, $junk, $junk)=split(/\0/,$val);
                if($tmp_subj eq $key || $tmp_msgid  eq $message_id) {
                        $RULE{"hdr_$num"}.="($count) hits.";
                        return($weight);
                        }
                }
                dbmclose(%hash);
        }
DONE:
delete($RULE{"hdr_$num"});
return $OK;
}

sub hdr_1 {
my $active=$FILTER_DOMAIN_AND_NAME;
goto DONE unless($active);
local($num,%hdr)=@_;
#
# Total weight for this chk
#
my $weight=1;
#
# Rule Description
#
$RULE{"hdr_$num"}="My domain and I are not found in recpt. list.";
#
# Rule Code
#
if(!$MY_EMAIL_PATTERN) { $MY_EMAIL_PATTERN=$UNAME;}
if(!$hdr{'to'})
  { delete($RULE{"hdr_$num"}); return $OK;}
if($hdr{'to'} =~ /$UNAME|$MY_EMAIL_PATTERN/i || $hdr{'cc'} =~ /$UNAME|$MY_EMAIL
_PATTERN/i)
  { delete($RULE{"hdr_$num"}); return $OK;}
if(@OTHER_EMAIL_PATTERNS != ())
  { foreach $PATTERN (@OTHER_EMAIL_PATTERNS)
    { foreach $HEADER (@OTHER_EMAIL_PATTERN_HEADERS)
      { if($hdr{$HEADER} =~ /$PATTERN/i)
        { delete($RULE{"hdr_$num"}); return $OK;}
    }
  }
}
if($hdr{'to'} =~ /$DOMAIN/i || $hdr{'cc'} =~ /$DOMAIN/i)
  { return ($weight/2);}
else { return($weight); }
DONE:
delete($RULE{"hdr_$num"});
return $OK;
}

sub hdr_2 {
my $active=$FILTER_SUBJECT_ALL_CAPS;
goto DONE unless($active);
local($num,%hdr)=@_;
#
# Weight for this chk
#
my $weight=1;
#
# Rule Description
#
$RULE{"hdr_$num"}="Subject line ALL CAPS";
#
# Rule Code
#
if(&allCaps($hdr{'subject'})) { return($weight);}
#if($hdr{'subject'} !~ /[a-z]+/) { return($weight);}
DONE:
delete($RULE{"hdr_$num"});
return($OK);
}

sub hdr_3 {
my $active=$FILTER_B_SPAM_CODE;
goto DONE unless($active);
local($num,%hdr)=@_;
#
# Weight for this chk
#
my $weight=3;
#
# Rule Description
#
$RULE{"hdr_$num"}="Subj. Contains the {B} spam code";
#
# Rule Code
#
if($hdr{'subject'}=~/.*\{[bB]\}.*/) { return($weight);}
DONE:
delete($RULE{"hdr_$num"});
return($OK);
}


sub hdr_4 {
my $active=$FILTER_INTERROGATIVE_SUBJECT;
goto DONE unless($active);
local($num,%hdr)=@_;
#
# Weight for this chk
#
my $weight=1;
#
# Rule Description
#
$RULE{"hdr_$num"}="Subject is interrogative.";
#
# Rule Code
#
if($hdr{'subject'}=~/\?$/) { return($weight);}
DONE:
delete($RULE{"hdr_$num"});
return($OK);
}


sub hdr_5 {
my $active=$FILTER_EXCITED_SUBJECT;
goto DONE unless($active);
local($num,%hdr)=@_;
#
# Weight for this chk
#
my $weight=1;
#
# Rule Description
#
$RULE{"hdr_$num"}="Sender is too excited (!)";
#
# Rule Code
#
if($hdr{'subject'}=~/\!+/) { return($weight);}
DONE:
delete($RULE{"hdr_$num"});
return($OK);
}

sub hdr_6 {
my $active=$FILTER_POST_ADDR;
goto DONE unless($active && $POST_ADDR);
local($num,%hdr)=@_;
#
# Weight for this chk
#
my $weight=1;
#
# Rule Description
#
$RULE{"hdr_$num"}="Usenet Addy and Subj. not a reply";
#
# Rule Code
#
if($hdr{'received'}=~/$POST_ADDR/i && $hdr{'subject'} !~ /^[rR][eE]:/)
        {return($weight);}
DONE:
delete($RULE{"hdr_$num"});
return($OK);
}

sub hdr_7 {
my $active=$FILTER_URGENT;
goto DONE unless($active);
local($num,%hdr)=@_;
#
# Weight for this chk
#
my $weight=1;
#
# Rule Description
#
$RULE{"hdr_$num"}="Message tagged as 'urgent'.";
#
# Rule Code
#
if($hdr{'priority'} =~ /^[uU]/) {return($weight);}
DONE:
delete($RULE{"hdr_$num"});
return($OK);
}

sub hdr_8 {
my $active=$FILTER_X_HEADERS;
goto DONE unless($active);
local($num,%hdr)=@_;
#
# Weight for this chk
#
my $weight=0;
#
$RULE{"hdr_$num"}="Contains X-headers:";
#
# Rule Code
#
my @bad_x=qw(X-PMFLAGS X-UIDL X-Advertisement);
my @hdrs=keys(%hdr);
foreach $x (@bad_x) {
        if(grep(/$x/i,@hdrs)) {
                $RULE{"hdr_$num"} .= " $x";
                $weight++;
                }
        }
return($weight) if($weight);
DONE:
delete($RULE{"hdr_$num"});
return($OK);
}

sub hdr_9 {
my $active=$FILTER_BOGUS_MESSAGE_ID;
goto DONE unless($active);
local($num,%hdr)=@_;
#
# Weight for this chk
#
my $weight=1;
#
$RULE{"hdr_$num"}="Message-Id looks bogus: $hdr{'message-id'}";
#
# Rule Code
#
$msg_id=~s/^<|>$//g;
my($junk,$host)=split(/@/,$hdr{'message-id'});
$host=~s/>$//;
my(@chunks)=split(/\./,$host);
#
# we're just going to match the last 2 components of the host part of
# the message id
my($pattern)="$chunks[$#chunks-1].$chunks[$#chunks]";
if($hdr{'received'} !~ /$pattern/i) { return($weight); }
DONE:
delete($RULE{"hdr_$num"});
return($OK);
}

sub hdr_10 {
my $active=$FILTER_YOU_AT_YOU;
goto DONE unless($active);
local($num,%hdr)=@_;
#
# Weight for this chk
#
my $weight=1;
#
$RULE{"hdr_$num"}="Sent to you\@you.com or similar.";
#
# Rule Code
#
if(!$hdr{'to'})
  { delete($RULE{"hdr_$num"}); return $OK;}
if($hdr{'to'} =~ /(yourdomain|you|your|public).(com|org|net)/i
        || $hdr{'cc'} =~ /(yourdomain|you|your|public).(com|org|net)/i)
  { return ($weight); }
DONE:
delete($RULE{"hdr_$num"});
return($OK);
}

sub hdr_11 {
my $active=$FILTER_FROM_NUMBER_SUFFIX;
goto DONE unless($active);
local($num,%hdr)=@_;
#
# Weight for this chk
#
my $weight=1;
#
$RULE{"hdr_$num"}="From: ends in numbers (delphi, cserve, AOL etc).";
#
# Rule Code
#
if(!$hdr{'from'})
  { delete($RULE{"hdr_$num"}); return $OK;}
if($hdr{'from'} =~ /\d+\@/) { return ($weight); }
DONE:
delete($RULE{"hdr_$num"});
return($OK);
}

sub hdr_12 {
my $active=$FILTER_FROM_AND_TO_SAME;
goto DONE unless($active);
local($num,%hdr)=@_;
#
# Weight for this chk
#
my $weight=1;
#
$RULE{"hdr_$num"}="From and to the same address";
#
# Rule Code
#
if(!$hdr{'from'})
  { delete($RULE{"hdr_$num"}); return $OK;}
if($hdr{'from'} eq $hdr{'to'}) { return ($weight); }
DONE:
delete($RULE{"hdr_$num"});
return($OK);
}

$HDR_RULES=13;

